-- =============================================RECEIPTS SCHEDULED EVENT===========================================================================
SET SQL_SAFE_UPDATES = 0;
SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='FEE_PAYMENT');
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'RECEIPT_DETAILS'); 


SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'DAILY_RECEIPT_DETAILS_TDP', 'SQL');
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) 
VALUES(@dtprvdrinputparamId+1,@dtproviderId+1,'T1.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);
SET @sqldtproviderId=(SELECT MAX(id) FROM sql_dtprovider);
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES(@sqldtproviderId+1,@dtproviderId+1,'SELECT DATE_FORMAT(a1.receipt_date,\'%d-%b-%Y\')  AS RECEIPT_DATE, a1.today_total_receipt as TODAYS_TOTAL_RECEIPTS,a1.today_total_amount as TODAYS_TOTAL_AMOUNT,\r\na2.total_receipts as TILL_DATE_TOTAL_RECEIPTS,a2.total_amount TILL_DATE_TOTAL_AMOUNT\r\nFROM\r\n(\r\n\r\nSELECT \r\n    COUNT(*) AS today_total_receipt,\r\n    SUM(receipt_header.amount) AS today_total_amount,\r\n    receipt_header.transactionDate AS receipt_date\r\nFROM\r\n    receipt_header\r\n        LEFT JOIN\r\n    academy_location ON receipt_header.academyLocationId = academy_location.id\r\nWHERE\r\n    receipt_header.status <> \'CANCELLED\'\r\n        AND receipt_header.transactionDate = CURDATE() \r\n        AND academy_location.id = namedParams\r\n\r\n) AS a1,\r\n(        \r\nSELECT \r\n    COUNT(*) AS total_receipts,\r\n    SUM(receipt_header.amount) AS total_amount\r\nFROM\r\n    receipt_header\r\n        LEFT JOIN\r\n    academy_location ON receipt_header.academyLocationId = academy_location.id\r\nWHERE\r\n    receipt_header.status <> \'CANCELLED\'\r\n        AND academy_location.id = namedParams\r\n        \r\n        ) AS a2','{\r\n    \"id\": 1,\r\n    \"searchResultViewColumns\": [\r\n        {\r\n            \"id\": 1,\r\n            \"value\": \"today_total_receipt\",\r\n            \"resultKey\": \"RECEIPT_DATE\",\r\n            \"displayCode\": \"\",\r\n            \"displayOrder\": 0\r\n        },\r\n	{\r\n            \"id\": 2,\r\n            \"value\": \"today_total_receipt\",\r\n            \"resultKey\": \"TODAYS_TOTAL_RECEIPTS\",\r\n            \"displayCode\": \"\",\r\n            \"displayOrder\": 1\r\n        },\r\n        {\r\n            \"id\": 3,\r\n            \"value\": \"today_total_amount\",\r\n            \"resultKey\": \"TODAYS_TOTAL_AMOUNT\",\r\n            \"displayCode\": \"\",\r\n            \"displayOrder\": 2\r\n        },\r\n        {\r\n            \"id\": 4,\r\n            \"value\": \"total_receipts\",\r\n            \"resultKey\": \"TILL_DATE_TOTAL_RECEIPTS\",\r\n            \"displayCode\": \"\",\r\n            \"displayOrder\": 3\r\n        },\r\n        {\r\n            \"id\": 5,\r\n            \"value\": \"total_amount\",\r\n            \"resultKey\": \"TILL_DATE_TOTAL_AMOUNT\",\r\n            \"displayCode\": \"\",\r\n            \"displayOrder\": 4\r\n        }\r\n    ]\r\n}');

SET @templatedtproviderId=(SELECT MAX(id) FROM template_dtprovider);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='RECEIPT_DETAILS');
SET @dataProviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='DAILY_RECEIPT_DETAILS_TDP');
INSERT INTO `template_dtprovider` (`id`, `msgSubCategoryId`, `dataProviderId`, `dataProviderName`) VALUES(@templatedtproviderId+1,@msgSubCategoryId,@dataProviderId,'MSG_DAILY_RECEIPTS_TDP');


SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'AL_COURSE_EXECUTION_OWNER_DL', 'SQL');
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) 
VALUES(@dtprvdrinputparamId+1,@dtproviderId+1,'T1.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);
SET @sqldtproviderId=(SELECT MAX(id) FROM sql_dtprovider);
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES(@sqldtproviderId+1,@dtproviderId+1,'SELECT T1.ownerId AS USER_ID FROM `academy_location_purpose` T1 WHERE T1.purposeCode="COURSE_EXECUTION" AND T1.`academyLocationId` IN (namedParams)',NULL);


SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='RECEIPT_DETAILS');
INSERT INTO `system_msg_event` (`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) VALUES(@systemmsgeventId+1,'2',@msgSubCategoryId,'DAILY_RECEIPT_DETAILS','DAILY_RECEIPT_DETAILS','SYSTEM_SCHEDULE','','','','','','','','DAILY_RECEIPT_DETAILS');

SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `repeatitionRuleId`, `intiationScheduleCronDef`, `sendingPriority`) VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, NULL, NULL, 'IMMEDIATE'); 

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`,`sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1,@sysmsgevtdefaultconfId+1, @msgScopeParamId); 
SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`,`sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1,@sysmsgevtdefaultconfId+1, @msgScopeParamId); 


SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @distrListProviderId=(SELECT id FROM `dtprovider` WHERE `dataProviderName`='AL_COURSE_EXECUTION_OWNER_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='ALOwner');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @distrListProviderId, NULL, @recipientTypeId); 

SET @sysmsgevtrcpntdocId=(SELECT MAX(id) FROM `sys_msg_evt_rcpnt_doc`);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE `paramKey`='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_rcpnt_doc` (`id`, `sysMsgEvtRcpntDefaultConfigId`, `docTypeId`, `docGenOwnerMappingDef`, `docGenParamMapDef`) VALUES(@sysmsgevtrcpntdocId+1,@sysmsgevtrcptdefaultconfId+1,NULL,@msgScopeParamId,'[{\"MSG_PARAM\":\"CONFIG_LEVEL_VALUE\",\"DOC_GEN_PARAM\":\"PRM_ACADEMY_LOCATION_ID\"}]');



-- Receipts Info dynamic doc queries START----
SET @doctypeId=(SELECT MAX(id) FROM dydt_document_type);
INSERT INTO `dydt_document_type` (`id`, `typeName`, `configLevelCode`, `whetherDeletable`, `typeCode`, `availableForAdhoc`, `whetherEditable`) 
VALUES (@doctypeId+1, 'Receipts Info Doc', 'ACADEMY_LOCATION_LEVEL', '1', 'RECEIPTS_INFO_DOC', '0', '1'); 

SET @docParamId=(SELECT id FROM dydt_document_param WHERE `paramCode`="PRM_ACADEMY_LOCATION_ID" LIMIT 0,1);

SET @dataProviderId=(SELECT MAX(id) FROM dydt_data_provider);
INSERT INTO `dydt_data_provider` (`id`, `providerName`, `priority`) VALUES (@dataProviderId+1, 'RECEIPTS_INFO_DATA_PROVIDER', '1'); 

SET @dataProviderParamId=(SELECT MAX(id) FROM dydt_data_provider_param);
INSERT INTO `dydt_data_provider_param` (`id`, `parameterId`, `typeCode`, `providerId`) VALUES (@dataProviderParamId+1, @docParamId, 'IN', @dataProviderId+1); 


SET @dataLineItemId=(SELECT MAX(id) FROM dydt_data_line_item);
INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `formattersDef`, `sqlWhereQueryDef`, `whetherMultiRecord`) VALUES (@dataLineItemId+1, @dataProviderId+1, 'DAILY_RECEIPTS_INFO', '1', NULL, '1', '1', 'SELECT  COUNT(*) AS total_no_of_receipt, SUM(receipt_header.amount)  AS total_amount, currency.currencyCode AS currency FROM receipt_header LEFT JOIN currency ON receipt_header.currencyId = currency.id LEFT JOIN academy_location ON receipt_header.academyLocationId = academy_location.id', 'PRM_ACADEMY_LOCATION_ID', 'total_no_of_receipt,total_amount,currency', NULL, 'WHERE receipt_header.status <> ''CANCELLED'' AND receipt_header.transactionDate = CURDATE() AND academy_location.id = PRM_ACADEMY_LOCATION_ID GROUP BY receipt_header.currencyId;', '1'); 
-- transalations START
SET @dydttemplateparamstranslations=(SELECT MAX(id) FROM dydt_templateparams_translations);
INSERT INTO `dydt_templateparams_translations` (`id`,`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES (@dydttemplateparamstranslations+1,'total_no_of_receipt', 'Today Total No Of Receipt', @dataLineItemId+1); 
SET @dydttemplateparamstranslations=(SELECT MAX(id) FROM dydt_templateparams_translations);
INSERT INTO `dydt_templateparams_translations` (`id`,`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES (@dydttemplateparamstranslations+1,'total_amount', 'Today Total Amount ', @dataLineItemId+1); 
SET @dydttemplateparamstranslations=(SELECT MAX(id) FROM dydt_templateparams_translations);
INSERT INTO `dydt_templateparams_translations` (`id`,`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES (@dydttemplateparamstranslations+1,'currency', 'currency', @dataLineItemId+1); 
SET @dydttemplateparamstranslations=(SELECT MAX(id) FROM dydt_templateparams_translations);
INSERT INTO `dydt_templateparams_translations` (`id`,`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES (@dydttemplateparamstranslations+1,'DAILY_RECEIPTS_INFO_TABLE_REP', 'Todays Receipts Info(Tabular)', @dataLineItemId+1); 
SET @dydttemplateparamstranslations=(SELECT MAX(id) FROM dydt_templateparams_translations);
INSERT INTO `dydt_templateparams_translations` (`id`,`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES (@dydttemplateparamstranslations+1,'DAILY_RECEIPTS_INFO_BULLETED_REP', 'Todays Receipts Info(Bulleted)', @dataLineItemId+1); 
-- transalations END

SET @dataLineItemId=(SELECT MAX(id) FROM dydt_data_line_item);
INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `formattersDef`, `sqlWhereQueryDef`, `whetherMultiRecord`) VALUES (@dataLineItemId+1, @dataProviderId+1, 'TILL_DATE_RECEIPTS_INFO', '1', NULL, '1', '1', 'SELECT  COUNT(*) AS total_no_of_receipt, SUM(receipt_header.amount)  AS total_amount, currency.currencyCode AS currency FROM receipt_header LEFT JOIN currency ON receipt_header.currencyId = currency.id LEFT JOIN academy_location ON receipt_header.academyLocationId = academy_location.id', 'PRM_ACADEMY_LOCATION_ID', 'total_no_of_receipt,total_amount,currency', NULL, 'WHERE receipt_header.status <> ''CANCELLED'' AND academy_location.id = PRM_ACADEMY_LOCATION_ID GROUP BY receipt_header.currencyId', '1'); 
-- transalations START
SET @dydttemplateparamstranslations=(SELECT MAX(id) FROM dydt_templateparams_translations);
INSERT INTO `dydt_templateparams_translations` (`id`,`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES (@dydttemplateparamstranslations+1,'total_no_of_receipt', 'Total No Of Receipt', @dataLineItemId+1); 
SET @dydttemplateparamstranslations=(SELECT MAX(id) FROM dydt_templateparams_translations);
INSERT INTO `dydt_templateparams_translations` (`id`,`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES (@dydttemplateparamstranslations+1,'total_amount', 'Total Amount', @dataLineItemId+1); 
SET @dydttemplateparamstranslations=(SELECT MAX(id) FROM dydt_templateparams_translations);
INSERT INTO `dydt_templateparams_translations` (`id`,`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES (@dydttemplateparamstranslations+1,'currency', 'currency', @dataLineItemId+1); 
SET @dydttemplateparamstranslations=(SELECT MAX(id) FROM dydt_templateparams_translations);
INSERT INTO `dydt_templateparams_translations` (`id`,`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES (@dydttemplateparamstranslations+1,'TILL_DATE_RECEIPTS_INFO_TABLE_REP', 'Total Receipts Info(Tabular)', @dataLineItemId+1); 
SET @dydttemplateparamstranslations=(SELECT MAX(id) FROM dydt_templateparams_translations);
INSERT INTO `dydt_templateparams_translations` (`id`,`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES (@dydttemplateparamstranslations+1,'TILL_DATE_RECEIPTS_INFO_BULLETED_REP', 'Total Receipts Info(Bulleted)', @dataLineItemId+1); 
-- transalations END

SET @dataLineItemId=(SELECT MAX(id) FROM dydt_data_line_item);
INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `formattersDef`, `sqlWhereQueryDef`, `whetherMultiRecord`) VALUES (@dataLineItemId+1, @dataProviderId+1, 'RECEIPTS_INFO', '1', NULL, '1', '1', 'SELECT  DATE_FORMAT(receipt_header.transactionDate,''%d-%b-%Y'') AS receipt_date FROM receipt_header LEFT JOIN academy_location ON receipt_header.academyLocationId = academy_location.id', 'PRM_ACADEMY_LOCATION_ID', 'receipt_date', NULL, 'WHERE receipt_header.status <> ''CANCELLED'' AND receipt_header.transactionDate = CURDATE() AND academy_location.id = PRM_ACADEMY_LOCATION_ID', '0'); 
-- transalations START
SET @dydttemplateparamstranslations=(SELECT MAX(id) FROM dydt_templateparams_translations);
INSERT INTO `dydt_templateparams_translations` (`id`,`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES (@dydttemplateparamstranslations+1,'receipt_date', 'Receipt Date', @dataLineItemId+1); 
-- transalations END


SET @docDataProviderId=(SELECT MAX(id) FROM dydt_document_data_provider);
INSERT INTO `dydt_document_data_provider` (`id`, `dataProviderId`, `documentTypeId`) VALUES (@docDataProviderId+1, @dataProviderId+1, @doctypeId+1); 

SET @templateConfigId=(SELECT MAX(id) FROM dydt_template_conf);
INSERT INTO `dydt_template_conf` (`id`, `documentTypeId`, `templateName`, `templateType`, `whetherDefault`, `previewImage`, `repeatHeader`, `repeatFooter`, `reportParams`, `templateContent`, `mainReportPath`) VALUES 
(@templateConfigId+1, @doctypeId+1, 'Receipt Info Template', 'HTMLTEMPLATE', '0', NULL, NULL, NULL, NULL, '<html>\r\n<head>\r\n	<title></title>\r\n</head>\r\n<body>\r\n<p>Receipts Details :</p>\r\n\r\n<p>For Date :&nbsp;$DATA.receipt_date</p>\r\n\r\n<p><!--TC  #if( $list.size($DATA.DAILY_RECEIPTS_INFO) !=0 ) --></p>\r\n\r\n<table border=\"1\" cellpadding=\"4\" cellspacing=\"0\">\r\n	<tbody>\r\n		<tr>\r\n			\r\n			<td>Currency</td>\r\n			<td>Total Amount</td>\r\n			<td>Total no of Receipt</td>\r\n		</tr>\r\n		<!--TC #foreach( $loopItem in $DATA.DAILY_RECEIPTS_INFO) -->\r\n		<tr>\r\n			\r\n			<td>$loopItem.currency</td>\r\n			<td>$loopItem.total_amount</td>\r\n			<td>$loopItem.total_no_of_receipt</td>\r\n		</tr>\r\n		<!--TC #end -->\r\n	</tbody>\r\n</table>\r\n<!--TC #end -->\r\n\r\n<p>Till Date :&nbsp;$DATA.receipt_date</p>\r\n\r\n<p><!--TC  #if( $list.size($DATA.TILL_DATE_RECEIPTS_INFO) !=0 ) --></p>\r\n\r\n<table border=\"1\" cellpadding=\"4\" cellspacing=\"0\">\r\n	<tbody>\r\n		<tr>\r\n			\r\n			<td>Currency</td>\r\n			<td>Total Amount</td>\r\n			<td>Total no of Receipt</td>\r\n		</tr>\r\n		<!--TC #foreach( $loopItem in $DATA.TILL_DATE_RECEIPTS_INFO) -->\r\n		<tr>\r\n			\r\n			<td>$loopItem.currency</td>\r\n			<td>$loopItem.total_amount</td>\r\n			<td>$loopItem.total_no_of_receipt</td>\r\n		</tr>\r\n		<!--TC #end -->\r\n	</tbody>\r\n</table>\r\n<!--TC #end -->\r\n\r\n<p>&nbsp;</p>\r\n</body>\r\n</html>\r\n', NULL); 

SET @ownerConfigId=(SELECT MAX(id) FROM dydt_owner_conf);
INSERT INTO `dydt_owner_conf` (`id`, `documentTypeId`, `ownerId`, `templateId`, `useDefaultTemplate`, `whetherActive`) VALUES 
(@ownerConfigId+1, @doctypeId+1, '1', @templateConfigId+1, '0', '1'); 
-- Receipts Info dynamic doc queries END----

UPDATE `sys_msg_evt_rcpnt_doc` SET `docTypeId` = @doctypeId+1 WHERE `id` = @sysmsgevtrcpntdocId+1; 


-- sample template config query START
SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='RECEIPT_DETAILS');
SET @sysMsgEventId=(SELECT id FROM `system_msg_event` WHERE `code`='DAILY_RECEIPT_DETAILS');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='ALOwner');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='GeneralMessage');
SET @templateDataProviderId=(SELECT id FROM `template_dtprovider` WHERE `dataProviderName`='MSG_DAILY_RECEIPTS_TDP');
INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`) VALUES(@msgtemplateconfigId+1,'RECEIPTS_DETAILS_TEMPLATE',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,@templateDataProviderId,NULL,'RECEIPTS_DETAILS_TEMPLATE',NULL,'',NULL,'','APPROVED','','3','System Admin System Admin','1');
SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) VALUES(@msgtemplateId+1,@msgtemplateconfigId+1,'1','Reciepts detials','<html>\n<head>\n	<title></title>\n</head>\n<body>\r\n<p>Dear &nbsp;$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]</p>\r\n\r\n<p>Please find Receipt Details for&nbsp;</p>\r\n\r\n<p>1) For Date:-&nbsp;$templateData[&quot;RECEIPT_DATE&quot;]<br />\r\nTotal Number of Receipts :- &nbsp;$templateData[&quot;TODAYS_TOTAL_RECEIPTS&quot;]<br />\r\nTotal Receipt Amount:- &nbsp;$templateData[&quot;TODAYS_TOTAL_AMOUNT&quot;]</p>\r\n\r\n<p>2) Till Date:-&nbsp;$templateData[&quot;RECEIPT_DATE&quot;]<br />\r\nTotal Number of Receipts&nbsp;:- &nbsp;$templateData[&quot;TILL_DATE_TOTAL_RECEIPTS&quot;]<br />\r\nTotal Receipt&nbsp;Amount:- &nbsp;$templateData[&quot;TILL_DATE_TOTAL_AMOUNT&quot;]</p>\r\n<p>For more details please find attached copy</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>Thanks,<br />\r\nAcademia V2</p>\r\n</body>\r\n</html>');
UPDATE `msg_template` SET `msgContent` = '<table align=\"center\" style=\"min-width:700px; max-width:800px; border-collapse:collapse\">				<tr style=\"background-color:#f0f0f0; line-height:20px;\"><td style=\"padding:20px 20px 20px 20px;\">				<p style=\"font-family:sans-serif, Arial, Helvetica; font-size:12px\">				Please find Receipt Details for - <br/><br/>							For Date: <b>$templateData[\"RECEIPT_DATE\"]</b><br />            Total Number of Receipts: <b>$templateData[\"TODAYS_TOTAL_RECEIPTS\"]</b><br />			Total Receipt Amount: <b>$templateData[\"TODAYS_TOTAL_AMOUNT\"]</b><br/><br/>			Till Date: <b>$templateData[\"RECEIPT_DATE\"]</b><br />			Total Number of Receipts: <b>$templateData[\"TILL_DATE_TOTAL_RECEIPTS\"]</b><br />			Total Receipt Amount: <b>$templateData[\"TILL_DATE_TOTAL_AMOUNT\"]</b><br/><br/> 			For more details please find attached copy.				</p>				</td></tr>				<tr><td  align=\"center\" style=\"background-color: #727272; margin:0px; padding:4px;\"><img src=\"http://www.serosoft.in/mailer/academia_email.png\" /></td></tr></table>' WHERE `id` = @msgtemplateId+1;

SET @msgtemplateconfigdocId=(SELECT MAX(id) FROM msg_template_config_doc);
INSERT INTO `msg_template_config_doc` (`id`, `msgTemplateconfigId`, `sysMsgEvtRcpntdocId`) VALUES (@msgtemplateconfigdocId+1, @msgtemplateconfigId+1, @sysmsgevtrcpntdocId+1); 
-- sample template config query END

-- ======================================BILLS SCHEDULED EVENT==================================================================================

SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='FEE_PAYMENT');
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'BILL_DETAILS'); 

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'DAILY_BILL_DETAILS_TDP', 'SQL');
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) 
VALUES(@dtprvdrinputparamId+1,@dtproviderId+1,'T1.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);
SET @sqldtproviderId=(SELECT MAX(id) FROM sql_dtprovider);
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES(@sqldtproviderId+1,@dtproviderId+1,'SELECT DATE_FORMAT(a1.bill_date,\'%d-%b-%Y\')  AS BILL_DATE,a1.today_total_bills AS TODAYS_TOTAL_BILLS,a1.today_total_amount AS TODAYS_TOTAL_AMOUNT,\r\na2.total_bills AS TILL_DATE_TOTAL_BILLS,a2.amount TILL_DATE_TOTAL_AMOUNT\r\nFROM\r\n(\r\n\r\nSELECT \r\n    COUNT(*) AS today_total_bills,\r\n    SUM(bill_fee_plan_rule_stage.billableAmount) AS today_total_amount,\r\n    bill_header.billingDate AS bill_date\r\nFROM\r\n    bill_header\r\n        LEFT JOIN\r\n    bill_fee_plan_rule_stage ON bill_header.id = bill_fee_plan_rule_stage.billId\r\n        LEFT JOIN\r\n    academy_location ON bill_header.academyLocationId = academy_location.id\r\nWHERE\r\n    bill_header.billStatus NOT IN (\'CANCELLED\' , \'REVERSED\')\r\n        AND bill_header.billingDate = CURDATE() \r\n        AND academy_location.id = namedParams\r\n) AS a1,\r\n(\r\nSELECT \r\n    COUNT(*) AS total_bills,\r\n    SUM(bill_fee_plan_rule_stage.billableAmount) AS amount\r\nFROM\r\n    bill_header\r\n        LEFT JOIN\r\n    bill_fee_plan_rule_stage ON bill_header.id = bill_fee_plan_rule_stage.billId\r\n        LEFT JOIN\r\n    academy_location ON bill_header.academyLocationId = academy_location.id\r\nWHERE\r\n    bill_header.billStatus NOT IN (\'CANCELLED\' , \'REVERSED\')\r\n        AND academy_location.id = namedParams\r\n) AS a2\r\n\r\n','{\r\n    \"id\": 1,\r\n    \"searchResultViewColumns\": [\r\n        {\r\n            \"id\": 1,\r\n            \"value\": \"bill_date\",\r\n            \"resultKey\": \"BILL_DATE\",\r\n            \"displayCode\": \"\",\r\n            \"displayOrder\": 0\r\n        },\r\n{\r\n            \"id\": 2,\r\n            \"value\": \"today_total_bills\",\r\n            \"resultKey\": \"TODAYS_TOTAL_BILLS\",\r\n            \"displayCode\": \"\",\r\n            \"displayOrder\": 1\r\n        },\r\n        {\r\n            \"id\": 3,\r\n            \"value\": \"today_total_amount\",\r\n            \"resultKey\": \"TODAYS_TOTAL_AMOUNT\",\r\n            \"displayCode\": \"\",\r\n            \"displayOrder\": 2\r\n        },\r\n        {\r\n            \"id\": 4,\r\n            \"value\": \"total_bills\",\r\n            \"resultKey\": \"TILL_DATE_TOTAL_BILLS\",\r\n            \"displayCode\": \"\",\r\n            \"displayOrder\": 3\r\n        },\r\n        {\r\n            \"id\": 5,\r\n            \"value\": \"amount\",\r\n            \"resultKey\": \"TILL_DATE_TOTAL_AMOUNT\",\r\n            \"displayCode\": \"\",\r\n            \"displayOrder\": 4\r\n        }\r\n    ]\r\n}');

SET @templatedtproviderId=(SELECT MAX(id) FROM template_dtprovider);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='BILL_DETAILS');
SET @dataProviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='DAILY_BILL_DETAILS_TDP');
INSERT INTO `template_dtprovider` (`id`, `msgSubCategoryId`, `dataProviderId`, `dataProviderName`) VALUES(@templatedtproviderId+1,@msgSubCategoryId,@dataProviderId,'MSG_DAILY_BILLS_TDP');

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='BILL_DETAILS');
INSERT INTO `system_msg_event` (`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) VALUES(@systemmsgeventId+1,'2',@msgSubCategoryId,'DAILY_BILLS_DETAILS','DAILY_BILLS_DETAILS','SYSTEM_SCHEDULE','','','','','','','','DAILY_BILLS_DETAILS');

SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `repeatitionRuleId`, `intiationScheduleCronDef`, `sendingPriority`) VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, NULL, NULL, 'IMMEDIATE'); 

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`,`sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1,@sysmsgevtdefaultconfId+1, @msgScopeParamId); 
SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`,`sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1,@sysmsgevtdefaultconfId+1, @msgScopeParamId); 

SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @distrListProviderId=(SELECT id FROM `dtprovider` WHERE `dataProviderName`='AL_COURSE_EXECUTION_OWNER_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='ALOwner');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @distrListProviderId, NULL, @recipientTypeId); 

SET @sysmsgevtrcpntdocId=(SELECT MAX(id) FROM `sys_msg_evt_rcpnt_doc`);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE `paramKey`='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_rcpnt_doc` (`id`, `sysMsgEvtRcpntDefaultConfigId`, `docTypeId`, `docGenOwnerMappingDef`, `docGenParamMapDef`) VALUES(@sysmsgevtrcpntdocId+1,@sysmsgevtrcptdefaultconfId+1,NULL,@msgScopeParamId,'[{\"MSG_PARAM\":\"CONFIG_LEVEL_VALUE\",\"DOC_GEN_PARAM\":\"PRM_ACADEMY_LOCATION_ID\"}]');

-- Receipts Info dynamic doc queries START----
SET @doctypeId=(SELECT MAX(id) FROM dydt_document_type);
INSERT INTO `dydt_document_type` (`id`, `typeName`, `configLevelCode`, `whetherDeletable`, `typeCode`, `availableForAdhoc`, `whetherEditable`) 
VALUES (@doctypeId+1, 'Bills Info Doc', 'ACADEMY_LOCATION_LEVEL', '1', 'BILLS_INFO_DOC', '0', '1'); 

SET @docParamId=(SELECT id FROM dydt_document_param WHERE `paramCode`="PRM_ACADEMY_LOCATION_ID" LIMIT 0,1);

SET @dataProviderId=(SELECT MAX(id) FROM dydt_data_provider);
INSERT INTO `dydt_data_provider` (`id`, `providerName`, `priority`) VALUES (@dataProviderId+1, 'BILLS_INFO_DATA_PROVIDER', '1'); 

SET @dataProviderParamId=(SELECT MAX(id) FROM dydt_data_provider_param);
INSERT INTO `dydt_data_provider_param` (`id`, `parameterId`, `typeCode`, `providerId`) VALUES (@dataProviderParamId+1, @docParamId, 'IN', @dataProviderId+1); 

SET @dataLineItemId=(SELECT MAX(id) FROM dydt_data_line_item);
INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `formattersDef`, `sqlWhereQueryDef`, `whetherMultiRecord`) VALUES (@dataLineItemId+1, @dataProviderId+1, 'DAILY_BILLS_INFO', '1', NULL, '1', '1', 'SELECT \r\n    COUNT(*) AS today_total_bills,\r\n    SUM(bill_fee_plan_rule_stage.billableAmount) AS today_total_amount,\r\n    currency.currencyCode AS currency\r\nFROM\r\n    bill_header\r\n        LEFT JOIN\r\n    bill_fee_plan_rule_stage ON bill_header.id = bill_fee_plan_rule_stage.billId\r\n        LEFT JOIN\r\n    currency ON bill_header.currencyId = currency.id\r\n        LEFT JOIN\r\n    academy_location ON bill_header.academyLocationId = academy_location.id\r\n', 'PRM_ACADEMY_LOCATION_ID', 'today_total_bills,today_total_amount,currency', NULL, 'WHERE\r\n    bill_header.billStatus NOT IN (\'CANCELLED\' , \'REVERSED\')\r\n        AND bill_header.billingDate = CURDATE()\r\n        AND academy_location.id = PRM_ACADEMY_LOCATION_ID\r\nGROUP BY bill_header.currencyId;', '1'); 
-- transalations START
SET @dydttemplateparamstranslations=(SELECT MAX(id) FROM dydt_templateparams_translations);
INSERT INTO `dydt_templateparams_translations` (`id`,`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES (@dydttemplateparamstranslations+1,'today_total_bills', 'Today No Of Bills', @dataLineItemId+1); 
SET @dydttemplateparamstranslations=(SELECT MAX(id) FROM dydt_templateparams_translations);
INSERT INTO `dydt_templateparams_translations` (`id`,`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES (@dydttemplateparamstranslations+1,'today_total_amount', 'Today Total Amount ', @dataLineItemId+1); 
SET @dydttemplateparamstranslations=(SELECT MAX(id) FROM dydt_templateparams_translations);
INSERT INTO `dydt_templateparams_translations` (`id`,`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES (@dydttemplateparamstranslations+1,'currency', 'Currency', @dataLineItemId+1); 
SET @dydttemplateparamstranslations=(SELECT MAX(id) FROM dydt_templateparams_translations);
INSERT INTO `dydt_templateparams_translations` (`id`,`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES (@dydttemplateparamstranslations+1,'DAILY_BILLS_INFO_TABLE_REP', 'Todays Bills Info(Tabular)', @dataLineItemId+1); 
SET @dydttemplateparamstranslations=(SELECT MAX(id) FROM dydt_templateparams_translations);
INSERT INTO `dydt_templateparams_translations` (`id`,`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES (@dydttemplateparamstranslations+1,'DAILY_BILLS_INFO_BULLETED_REP', 'Todays Bills Info(Bulleted)', @dataLineItemId+1); 

-- transalations END

SET @dataLineItemId=(SELECT MAX(id) FROM dydt_data_line_item);
INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `formattersDef`, `sqlWhereQueryDef`, `whetherMultiRecord`) VALUES (@dataLineItemId+1, @dataProviderId+1, 'TILL_DATE_BILLS_INFO', '1', NULL, '1', '1', 'SELECT \r\n    COUNT(*) AS total_bills,\r\n    SUM(bill_fee_plan_rule_stage.billableAmount) AS total_amount,\r\n    currency.currencyCode AS currency\r\nFROM\r\n    bill_header\r\n        LEFT JOIN\r\n    bill_fee_plan_rule_stage ON bill_header.id = bill_fee_plan_rule_stage.billId\r\n        LEFT JOIN\r\n    currency ON bill_header.currencyId = currency.id\r\n        LEFT JOIN\r\n    academy_location ON bill_header.academyLocationId = academy_location.id\r\n', 'PRM_ACADEMY_LOCATION_ID', 'total_bills,total_amount,currency', NULL, 'WHERE\r\n    bill_header.billStatus NOT IN (\'CANCELLED\' , \'REVERSED\')\r\n        AND academy_location.id = PRM_ACADEMY_LOCATION_ID\r\nGROUP BY bill_header.currencyId;', '1'); 
-- transalations START
SET @dydttemplateparamstranslations=(SELECT MAX(id) FROM dydt_templateparams_translations);
INSERT INTO `dydt_templateparams_translations` (`id`,`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES (@dydttemplateparamstranslations+1,'total_bills', 'Total No Of Bills', @dataLineItemId+1); 
SET @dydttemplateparamstranslations=(SELECT MAX(id) FROM dydt_templateparams_translations);
INSERT INTO `dydt_templateparams_translations` (`id`,`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES (@dydttemplateparamstranslations+1,'total_amount', 'Total Amount ', @dataLineItemId+1); 
SET @dydttemplateparamstranslations=(SELECT MAX(id) FROM dydt_templateparams_translations);
INSERT INTO `dydt_templateparams_translations` (`id`,`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES (@dydttemplateparamstranslations+1,'currency', 'Currency', @dataLineItemId+1); 
SET @dydttemplateparamstranslations=(SELECT MAX(id) FROM dydt_templateparams_translations);
INSERT INTO `dydt_templateparams_translations` (`id`,`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES (@dydttemplateparamstranslations+1,'TILL_DATE_BILLS_INFO_TABLE_REP', 'Total Bills Info(Tabular)', @dataLineItemId+1); 
SET @dydttemplateparamstranslations=(SELECT MAX(id) FROM dydt_templateparams_translations);
INSERT INTO `dydt_templateparams_translations` (`id`,`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES (@dydttemplateparamstranslations+1,'TILL_DATE_BILLS_INFO_BULLETED_REP', 'Total Bills Info(Bulleted)', @dataLineItemId+1); 

-- transalations END

SET @dataLineItemId=(SELECT MAX(id) FROM dydt_data_line_item);
INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `formattersDef`, `sqlWhereQueryDef`, `whetherMultiRecord`) VALUES (@dataLineItemId+1, @dataProviderId+1, 'BILLS_INFO', '1', NULL, '1', '1', 'SELECT \r\n    DATE_FORMAT(bill_header.billingDate,\'%d-%b-%Y\') AS bill_date\r\nFROM\r\n    bill_header\r\n        LEFT JOIN\r\n    bill_fee_plan_rule_stage ON bill_header.id = bill_fee_plan_rule_stage.billId\r\n        LEFT JOIN\r\n    academy_location ON bill_header.academyLocationId = academy_location.id\r\n\r\n', 'PRM_ACADEMY_LOCATION_ID', 'bill_date', NULL, 'WHERE\r\n    bill_header.billStatus NOT IN (\'CANCELLED\' , \'REVERSED\')\r\n        AND bill_header.billingDate = CURDATE()\r\n        AND academy_location.id = PRM_ACADEMY_LOCATION_ID', '0'); 
-- transalations START
SET @dydttemplateparamstranslations=(SELECT MAX(id) FROM dydt_templateparams_translations);
INSERT INTO `dydt_templateparams_translations` (`id`,`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES (@dydttemplateparamstranslations+1,'bill_date', 'Bill Date', @dataLineItemId+1); 
-- transalations END

SET @docDataProviderId=(SELECT MAX(id) FROM dydt_document_data_provider);
INSERT INTO `dydt_document_data_provider` (`id`, `dataProviderId`, `documentTypeId`) VALUES (@docDataProviderId+1, @dataProviderId+1, @doctypeId+1); 

SET @templateConfigId=(SELECT MAX(id) FROM dydt_template_conf);
INSERT INTO `dydt_template_conf` (`id`, `documentTypeId`, `templateName`, `templateType`, `whetherDefault`, `previewImage`, `repeatHeader`, `repeatFooter`, `reportParams`, `templateContent`, `mainReportPath`) VALUES 
(@templateConfigId+1, @doctypeId+1, 'Bills Info Template', 'HTMLTEMPLATE', '0', NULL, NULL, NULL, NULL, '<html>\r\n<head>\r\n	<title></title>\r\n</head>\r\n<body>\r\n<p>Bill Details</p>\r\n\r\n<p>For Date :&nbsp;$DATA.bill_date</p>\r\n\r\n<p><!--TC  #if( $list.size($DATA.DAILY_BILLS_INFO) !=0 ) --></p>\r\n\r\n<table border=\"1\" cellpadding=\"4\" cellspacing=\"0\">\r\n	<tbody>\r\n		<tr>\r\n			<td>Currency</td>\r\n			<td>Today Total Amount</td>\r\n			<td>Today Total Bills</td>\r\n		</tr>\r\n		<!--TC #foreach( $loopItem in $DATA.DAILY_BILLS_INFO) -->\r\n		<tr>\r\n			<td>$loopItem.currency</td>\r\n			<td>$loopItem.today_total_amount</td>\r\n			<td>$loopItem.today_total_bills</td>\r\n		</tr>\r\n		<!--TC #end -->\r\n	</tbody>\r\n</table>\r\n<!--TC #end -->\r\n\r\n<p>Till Date :&nbsp;$DATA.bill_date</p>\r\n\r\n<p><!--TC  #if( $list.size($DATA.TILL_DATE_BILLS_INFO) !=0 ) --></p>\r\n\r\n<table border=\"1\" cellpadding=\"4\" cellspacing=\"0\">\r\n	<tbody>\r\n		<tr>\r\n			<td>Currency</td>\r\n			<td>Total Amount</td>\r\n			<td>Total Bills</td>\r\n		</tr>\r\n		<!--TC #foreach( $loopItem in $DATA.TILL_DATE_BILLS_INFO) -->\r\n		<tr>\r\n			<td>$loopItem.currency</td>\r\n			<td>$loopItem.total_amount</td>\r\n			<td>$loopItem.total_bills</td>\r\n		</tr>\r\n		<!--TC #end -->\r\n	</tbody>\r\n</table>\r\n<!--TC #end -->\r\n\r\n<p>&nbsp;</p>\r\n</body>\r\n</html>\r\n', NULL); 

SET @ownerConfigId=(SELECT MAX(id) FROM dydt_owner_conf);
INSERT INTO `dydt_owner_conf` (`id`, `documentTypeId`, `ownerId`, `templateId`, `useDefaultTemplate`, `whetherActive`) VALUES 
(@ownerConfigId+1, @doctypeId+1, '1', @templateConfigId+1, '0', '1'); 

-- Receipts Info dynamic doc queries END----

UPDATE `sys_msg_evt_rcpnt_doc` SET `docTypeId` = @doctypeId+1 WHERE `id` = @sysmsgevtrcpntdocId+1; 

-- sample template config query START
SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='BILL_DETAILS');
SET @sysMsgEventId=(SELECT id FROM `system_msg_event` WHERE `code`='DAILY_BILLS_DETAILS');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='ALOwner');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='GeneralMessage');
SET @templateDataProviderId=(SELECT id FROM `template_dtprovider` WHERE `dataProviderName`='MSG_DAILY_BILLS_TDP');
INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`) VALUES(@msgtemplateconfigId+1,'BILL_DETAILS_TEMPLATE',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,@templateDataProviderId,NULL,'BILL_DETAILS_TEMPLATE',NULL,'',NULL,'','APPROVED','','3','System Admin System Admin','1');
SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) VALUES(@msgtemplateId+1,@msgtemplateconfigId+1,'1','Bills Details','<html><head>	<title></title></head><body><p>Dear &nbsp;$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]</p><p>Please find Bill Details for&nbsp;</p><p>1) For Date:-&nbsp;$templateData[&quot;BILL_DATE&quot;]<br />Total Number of Bills :- &nbsp;$templateData[&quot;TODAYS_TOTAL_BILLS&quot;]<br />Total Bill Amount:- &nbsp;$templateData[&quot;TODAYS_TOTAL_AMOUNT&quot;]</p><p>2) Till Date:-&nbsp;$templateData[&quot;BILL_DATE&quot;]<br />Total Number of Bills&nbsp;:- &nbsp;$templateData[&quot;TILL_DATE_TOTAL_BILLS&quot;]<br />Total Bill&nbsp;Amount:- &nbsp;$templateData[&quot;TILL_DATE_TOTAL_AMOUNT&quot;]</p><p>For more details please find attached copy</p><p>&nbsp;</p><p>Thanks,<br />Academia V2</p></body></html>');
UPDATE `msg_template` SET `msgContent` = '<table align=\"center\" style=\"min-width:700px; max-width:800px; border-collapse:collapse\">				<tr style=\"background-color:#f0f0f0; line-height:20px;\"><td style=\"padding:20px 20px 20px 20px;\">				<p style=\"font-family:sans-serif, Arial, Helvetica; font-size:12px\">				Please find Bill Details for - <br/><br/>							For Date: <b>$templateData[\"BILL_DATE\"]</b><br />            Total Number of Bills: <b>$templateData[\"TODAYS_TOTAL_BILLS\"]</b><br />			Total Bill Amount: <b>$templateData[\"TODAYS_TOTAL_AMOUNT\"]</b><br/><br/>			Till Date: <b>$templateData[\"BILL_DATE\"]</b><br />			Total Number of Bills: <b>$templateData[\"TILL_DATE_TOTAL_BILLS\"]</b><br />			Total Receipt Amount: <b>$templateData[\"TILL_DATE_TOTAL_AMOUNT\"]</b><br/><br/>			For more details please find attached copy.				</p>				</td></tr>				<tr><td  align=\"center\" style=\"background-color: #727272; margin:0px; padding:4px;\"><img src=\"http://www.serosoft.in/mailer/academia_email.png\" /></td></tr></table>' WHERE `id` = @msgtemplateId+1;

SET @msgtemplateconfigdocId=(SELECT MAX(id) FROM msg_template_config_doc);
INSERT INTO `msg_template_config_doc` (`id`, `msgTemplateconfigId`, `sysMsgEvtRcpntdocId`) VALUES (@msgtemplateconfigdocId+1, @msgtemplateconfigId+1, @sysmsgevtrcpntdocId+1); 

-- sample template config query END

-- =====================================PAYMENT SCHEDULED EVENT===================================================================================

SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='FEE_PAYMENT');
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'PAYMENT_DETAILS');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'DAILY_PAYMENT_DETAILS_TDP', 'SQL');
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) 
VALUES(@dtprvdrinputparamId+1,@dtproviderId+1,'T1.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);
SET @sqldtproviderId=(SELECT MAX(id) FROM sql_dtprovider);
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES(@sqldtproviderId+1,@dtproviderId+1,'SELECT DATE_FORMAT(a1.payment_date,\'%d-%b-%Y\')  AS PAYMENT_DATE,a1.today_total_payment AS TODAYS_TOTAL_PAYMENTS,a1.today_total_amount AS TODAYS_TOTAL_AMOUNT,\r\na2.total_payment AS TILL_DATE_TOTAL_PAYEMNTS,a2.amount TILL_DATE_TOTAL_AMOUNT\r\nFROM\r\n(\r\n\r\n\r\nSELECT \r\n    COUNT(*) AS today_total_payment,\r\n    SUM(payment_header.amount) AS today_total_amount,\r\n    payment_header.transactionDate AS payment_date\r\nFROM\r\n    payment_header\r\n        LEFT JOIN\r\n    academy_location ON payment_header.academyLocationId = academy_location.id\r\nWHERE\r\n    payment_header.status <> \'CANCELLED\'\r\n        AND payment_header.transactionDate = CURDATE() \r\n        AND academy_location.id = namedParams\r\n) AS a1,\r\n(\r\n\r\nSELECT \r\n    COUNT(*) AS total_payment ,\r\n    SUM(payment_header.amount) AS amount\r\nFROM\r\n    payment_header\r\n        LEFT JOIN\r\n    academy_location ON payment_header.academyLocationId = academy_location.id\r\nWHERE\r\n    payment_header.status <> \'CANCELLED\'\r\n        AND academy_location.id = namedParams\r\n) AS a2\r\n','{\r\n    \"id\": 1,\r\n    \"searchResultViewColumns\": [\r\n        {\r\n            \"id\": 1,\r\n            \"value\": \"payment_date\",\r\n            \"resultKey\": \"PAYMENT_DATE\",\r\n            \"displayCode\": \"\",\r\n            \"displayOrder\": 0\r\n        },\r\n	{\r\n            \"id\": 2,\r\n            \"value\": \"today_total_payment\",\r\n            \"resultKey\": \"TODAYS_TOTAL_PAYMENTS\",\r\n            \"displayCode\": \"\",\r\n            \"displayOrder\": 1\r\n        },\r\n        {\r\n            \"id\": 3,\r\n            \"value\": \"today_total_amount\",\r\n            \"resultKey\": \"TODAYS_TOTAL_AMOUNT\",\r\n            \"displayCode\": \"\",\r\n            \"displayOrder\": 2\r\n        },\r\n        {\r\n            \"id\": 4,\r\n            \"value\": \"total_payment\",\r\n            \"resultKey\": \"TILL_DATE_TOTAL_PAYEMNTS\",\r\n            \"displayCode\": \"\",\r\n            \"displayOrder\": 3\r\n        },\r\n        {\r\n            \"id\": 5,\r\n            \"value\": \"amount\",\r\n            \"resultKey\": \"TILL_DATE_TOTAL_AMOUNT\",\r\n            \"displayCode\": \"\",\r\n            \"displayOrder\": 4\r\n        }\r\n    ]\r\n}');

SET @templatedtproviderId=(SELECT MAX(id) FROM template_dtprovider);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='PAYMENT_DETAILS');
SET @dataProviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='DAILY_PAYMENT_DETAILS_TDP');
INSERT INTO `template_dtprovider` (`id`, `msgSubCategoryId`, `dataProviderId`, `dataProviderName`) VALUES(@templatedtproviderId+1,@msgSubCategoryId,@dataProviderId,'MSG_DAILY_PAYMENTS_TDP');

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='PAYMENT_DETAILS');
INSERT INTO `system_msg_event` (`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) VALUES(@systemmsgeventId+1,'2',@msgSubCategoryId,'DAILY_PAYMENT_DETAILS','DAILY_PAYMENT_DETAILS','SYSTEM_SCHEDULE','','','','','','','','DAILY_PAYMENT_DETAILS');

SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `repeatitionRuleId`, `intiationScheduleCronDef`, `sendingPriority`) VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, NULL, NULL, 'IMMEDIATE'); 

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`,`sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1,@sysmsgevtdefaultconfId+1, @msgScopeParamId); 
SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`,`sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1,@sysmsgevtdefaultconfId+1, @msgScopeParamId); 

SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @distrListProviderId=(SELECT id FROM `dtprovider` WHERE `dataProviderName`='AL_COURSE_EXECUTION_OWNER_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='ALOwner');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @distrListProviderId, NULL, @recipientTypeId); 

SET @sysmsgevtrcpntdocId=(SELECT MAX(id) FROM `sys_msg_evt_rcpnt_doc`);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE `paramKey`='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_rcpnt_doc` (`id`, `sysMsgEvtRcpntDefaultConfigId`, `docTypeId`, `docGenOwnerMappingDef`, `docGenParamMapDef`) VALUES(@sysmsgevtrcpntdocId+1,@sysmsgevtrcptdefaultconfId+1,NULL,@msgScopeParamId,'[{\"MSG_PARAM\":\"CONFIG_LEVEL_VALUE\",\"DOC_GEN_PARAM\":\"PRM_ACADEMY_LOCATION_ID\"}]');

-- Payment Info dynamic doc queries START
SET @doctypeId=(SELECT MAX(id) FROM dydt_document_type);
INSERT INTO `dydt_document_type` (`id`, `typeName`, `configLevelCode`, `whetherDeletable`, `typeCode`, `availableForAdhoc`, `whetherEditable`) 
VALUES (@doctypeId+1, 'Payment Info Doc', 'ACADEMY_LOCATION_LEVEL', '1', 'PAYMENT_INFO_DOC', '0', '1'); 

SET @docParamId=(SELECT id FROM dydt_document_param WHERE `paramCode`="PRM_ACADEMY_LOCATION_ID" LIMIT 0,1);

SET @dataProviderId=(SELECT MAX(id) FROM dydt_data_provider);
INSERT INTO `dydt_data_provider` (`id`, `providerName`, `priority`) VALUES (@dataProviderId+1, 'PAYEMNTS_INFO_DATA_PROVIDER', '1'); 

SET @dataProviderParamId=(SELECT MAX(id) FROM dydt_data_provider_param);
INSERT INTO `dydt_data_provider_param` (`id`, `parameterId`, `typeCode`, `providerId`) VALUES (@dataProviderParamId+1, @docParamId, 'IN', @dataProviderId+1); 

SET @dataLineItemId=(SELECT MAX(id) FROM dydt_data_line_item);
INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `formattersDef`, `sqlWhereQueryDef`, `whetherMultiRecord`) VALUES (@dataLineItemId+1, @dataProviderId+1, 'DAILY_PAYEMNTS_INFO', '1', NULL, '1', '1', 'SELECT \r\n    COUNT(*) AS today_total_payment,\r\n    currency.currencyCode AS currency,\r\n    SUM(payment_header.amount) AS today_total_amount\r\nFROM\r\n    payment_header\r\n        LEFT JOIN\r\n    currency ON payment_header.currencyId = currency.id\r\n        LEFT JOIN\r\n    academy_location ON payment_header.academyLocationId = academy_location.id\r\n','PRM_ACADEMY_LOCATION_ID', 'today_total_payment,currency,today_total_amount', NULL, 'WHERE\r\n    payment_header.status <> \'CANCELLED\'\r\n        AND payment_header.transactionDate = CURDATE()\r\n        AND academy_location.id = PRM_ACADEMY_LOCATION_ID\r\nGROUP BY payment_header.currencyId;\r\n', '1'); 
-- transalations START
SET @dydttemplateparamstranslations=(SELECT MAX(id) FROM dydt_templateparams_translations);
INSERT INTO `dydt_templateparams_translations` (`id`,`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES (@dydttemplateparamstranslations+1,'today_total_payment', 'Today No Of Payments', @dataLineItemId+1); 
SET @dydttemplateparamstranslations=(SELECT MAX(id) FROM dydt_templateparams_translations);
INSERT INTO `dydt_templateparams_translations` (`id`,`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES (@dydttemplateparamstranslations+1,'today_total_amount', 'Today Total Amount ', @dataLineItemId+1); 
SET @dydttemplateparamstranslations=(SELECT MAX(id) FROM dydt_templateparams_translations);
INSERT INTO `dydt_templateparams_translations` (`id`,`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES (@dydttemplateparamstranslations+1,'currency', 'Currency', @dataLineItemId+1); 
SET @dydttemplateparamstranslations=(SELECT MAX(id) FROM dydt_templateparams_translations);
INSERT INTO `dydt_templateparams_translations` (`id`,`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES (@dydttemplateparamstranslations+1,'DAILY_PAYEMNTS_INFO_TABLE_REP', 'Todays Payments Info(Tabular)', @dataLineItemId+1); 
SET @dydttemplateparamstranslations=(SELECT MAX(id) FROM dydt_templateparams_translations);
INSERT INTO `dydt_templateparams_translations` (`id`,`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES (@dydttemplateparamstranslations+1,'DAILY_PAYEMNTS_INFO_BULLETED_REP', 'Todays Payments Info(Bulleted)', @dataLineItemId+1); 
-- transalations END

SET @dataLineItemId=(SELECT MAX(id) FROM dydt_data_line_item);
INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `formattersDef`, `sqlWhereQueryDef`, `whetherMultiRecord`) VALUES (@dataLineItemId+1, @dataProviderId+1, 'TILL_DATE_PAYEMNTS_INFO', '1', NULL, '1', '1', 'SELECT \r\n    COUNT(*) AS total_payment,\r\n    currency.currencyCode AS currency,\r\n    SUM(payment_header.amount) AS total_amount\r\n   \r\nFROM\r\n    payment_header\r\n       LEFT JOIN\r\n   currency ON payment_header.currencyId = currency.id\r\n        LEFT JOIN\r\n    academy_location ON payment_header.academyLocationId = academy_location.id\r\n\r\n', 'PRM_ACADEMY_LOCATION_ID', 'total_payment,currency,total_amount', NULL, 'WHERE\r\n    payment_header.status <> \'CANCELLED\'\r\n        AND academy_location.id = PRM_ACADEMY_LOCATION_ID\r\n GROUP BY payment_header.currencyId;', '1'); 
-- transalations START
SET @dydttemplateparamstranslations=(SELECT MAX(id) FROM dydt_templateparams_translations);
INSERT INTO `dydt_templateparams_translations` (`id`,`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES (@dydttemplateparamstranslations+1,'total_payment', 'Total No Of Payments', @dataLineItemId+1); 
SET @dydttemplateparamstranslations=(SELECT MAX(id) FROM dydt_templateparams_translations);
INSERT INTO `dydt_templateparams_translations` (`id`,`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES (@dydttemplateparamstranslations+1,'total_amount', 'Total Amount ', @dataLineItemId+1); 
SET @dydttemplateparamstranslations=(SELECT MAX(id) FROM dydt_templateparams_translations);
INSERT INTO `dydt_templateparams_translations` (`id`,`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES (@dydttemplateparamstranslations+1,'currency', 'Currency', @dataLineItemId+1); 
SET @dydttemplateparamstranslations=(SELECT MAX(id) FROM dydt_templateparams_translations);
INSERT INTO `dydt_templateparams_translations` (`id`,`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES (@dydttemplateparamstranslations+1,'TILL_DATE_PAYEMNTS_INFO_TABLE_REP', 'Total Payments Info(Tabular)', @dataLineItemId+1); 
SET @dydttemplateparamstranslations=(SELECT MAX(id) FROM dydt_templateparams_translations);
INSERT INTO `dydt_templateparams_translations` (`id`,`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES (@dydttemplateparamstranslations+1,'TILL_DATE_PAYEMNTS_INFO_BULLETED_REP', 'Total Payments Info(Bulleted)', @dataLineItemId+1); 

-- transalations END

SET @dataLineItemId=(SELECT MAX(id) FROM dydt_data_line_item);
INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `formattersDef`, `sqlWhereQueryDef`, `whetherMultiRecord`) VALUES (@dataLineItemId+1, @dataProviderId+1, 'PAYEMNTS_INFO', '1', NULL, '1', '1', 'SELECT \r\n   DATE_FORMAT(payment_header.transactionDate,\'%d-%b-%Y\') AS payemnt_date\r\nFROM\r\n    payment_header\r\n       LEFT JOIN\r\n    academy_location ON payment_header.academyLocationId = academy_location.id\r\n\r\n', 'PRM_ACADEMY_LOCATION_ID', 'payemnt_date', NULL, 'WHERE\r\n    payment_header.status <> \'CANCELLED\'\r\n        AND academy_location.id = PRM_ACADEMY_LOCATION_ID\r\n        AND payment_header.transactionDate =CURDATE()', '0'); 
-- transalations START
SET @dydttemplateparamstranslations=(SELECT MAX(id) FROM dydt_templateparams_translations);
INSERT INTO `dydt_templateparams_translations` (`id`,`translationCode`, `translationValue`, `dataProviderLineItemId`) VALUES (@dydttemplateparamstranslations+1,'payemnt_date', 'Payement Date', @dataLineItemId+1); 
-- transalations END


SET @docDataProviderId=(SELECT MAX(id) FROM dydt_document_data_provider);
INSERT INTO `dydt_document_data_provider` (`id`, `dataProviderId`, `documentTypeId`) VALUES (@docDataProviderId+1, @dataProviderId+1, @doctypeId+1); 

SET @templateConfigId=(SELECT MAX(id) FROM dydt_template_conf);
INSERT INTO `dydt_template_conf` (`id`, `documentTypeId`, `templateName`, `templateType`, `whetherDefault`, `previewImage`, `repeatHeader`, `repeatFooter`, `reportParams`, `templateContent`, `mainReportPath`) VALUES 
(@templateConfigId+1, @doctypeId+1, 'Payments Info Template', 'HTMLTEMPLATE', '0', NULL, NULL, NULL, NULL, '<html>\r\n<head>\r\n	<title></title>\r\n</head>\r\n<body>\r\n<p>Payment Details</p>\r\n\r\n<p>For Date :&nbsp;$DATA.payemnt_date</p>\r\n\r\n<p><!--TC  #if( $list.size($DATA.DAILY_PAYEMNTS_INFO) !=0 ) --></p>\r\n\r\n<table border=\"1\" cellpadding=\"4\" cellspacing=\"0\">\r\n	<tbody>\r\n		<tr>\r\n			<td>Currency</td>\r\n			<td>Today Total Amount</td>\r\n			<td>Today Total Payment</td>\r\n		</tr>\r\n		<!--TC #foreach( $loopItem in $DATA.DAILY_PAYEMNTS_INFO) -->\r\n		<tr>\r\n			<td>$loopItem.currency</td>\r\n			<td>$loopItem.today_total_amount</td>\r\n			<td>$loopItem.today_total_payment</td>\r\n		</tr>\r\n		<!--TC #end -->\r\n	</tbody>\r\n</table>\r\n<!--TC #end -->\r\n\r\n<p>Till Date :&nbsp;$DATA.payemnt_date</p>\r\n\r\n<p><!--TC  #if( $list.size($DATA.TILL_DATE_PAYEMNTS_INFO) !=0 ) --></p>\r\n\r\n<table border=\"1\" cellpadding=\"4\" cellspacing=\"0\">\r\n	<tbody>\r\n		<tr>\r\n			<td>Currency</td>\r\n			<td>Total Amount</td>\r\n			<td>Total Payment</td>\r\n		</tr>\r\n		<!--TC #foreach( $loopItem in $DATA.TILL_DATE_PAYEMNTS_INFO) -->\r\n		<tr>\r\n			<td>$loopItem.currency</td>\r\n			<td>$loopItem.total_amount</td>\r\n			<td>$loopItem.total_payment</td>\r\n		</tr>\r\n		<!--TC #end -->\r\n	</tbody>\r\n</table>\r\n<!--TC #end -->\r\n\r\n<p>&nbsp;</p>\r\n</body>\r\n</html>\r\n', NULL); 

SET @ownerConfigId=(SELECT MAX(id) FROM dydt_owner_conf);
INSERT INTO `dydt_owner_conf` (`id`, `documentTypeId`, `ownerId`, `templateId`, `useDefaultTemplate`, `whetherActive`) VALUES 
(@ownerConfigId+1, @doctypeId+1, '1', @templateConfigId+1, '0', '1'); 

-- Payment Info dynamic doc queries END
UPDATE `sys_msg_evt_rcpnt_doc` SET `docTypeId` = @doctypeId+1 WHERE `id` = @sysmsgevtrcpntdocId+1; 

-- sample template config query START
SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='PAYMENT_DETAILS');
SET @sysMsgEventId=(SELECT id FROM `system_msg_event` WHERE `code`='DAILY_PAYMENT_DETAILS');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='ALOwner');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='GeneralMessage');
SET @templateDataProviderId=(SELECT id FROM `template_dtprovider` WHERE `dataProviderName`='MSG_DAILY_PAYMENTS_TDP');
INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`) VALUES(@msgtemplateconfigId+1,'PAYMENT_DETAILS_TEMPLATE',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,@templateDataProviderId,NULL,'PAYMENT_DETAILS_TEMPLATE',NULL,'',NULL,'','APPROVED','','3','System Admin System Admin','1');
SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) VALUES(@msgtemplateId+1,@msgtemplateconfigId+1,'1','Payment Details','<html>\r\n<head>\r\n	<title></title>\r\n</head>\r\n<body>\r\n<p>Dear &nbsp;$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]</p>\r\n\r\n<p>Please find Payment Details for&nbsp;</p>\r\n\r\n<p>1) For Date:-&nbsp;$templateData[&quot;PAYMENT_DATE&quot;]<br />\r\nTotal Number of Payments :- &nbsp;$templateData[&quot;TODAYS_TOTAL_PAYMENTS&quot;]<br />\r\nTotal Payment Amount:- &nbsp;$templateData[&quot;TODAYS_TOTAL_AMOUNT&quot;]</p>\r\n\r\n<p>2) Till Date:-&nbsp;$templateData[&quot;PAYMENT_DATE&quot;]<br />\r\nTotal Number of Payments&nbsp;:- &nbsp;$templateData[&quot;TILL_DATE_TOTAL_PAYEMNTS&quot;]<br />\r\nTotal Payment&nbsp;Amount:- &nbsp;$templateData[&quot;TILL_DATE_TOTAL_AMOUNT&quot;]</p>\r\n\r\n<p>For more details please find attached copy.</p>\r\n\r\n<p>Thanks,<br />\r\nAcademia V2</p>\r\n</body>\r\n</html>\r\n');
UPDATE `msg_template` SET `msgContent` = '<table align=\"center\" style=\"min-width:700px; max-width:800px; border-collapse:collapse\">				<tr style=\"background-color:#f0f0f0; line-height:20px;\"><td style=\"padding:20px 20px 20px 20px;\">				<p style=\"font-family:sans-serif, Arial, Helvetica; font-size:12px\">				Please find Payment Details for - <br/><br/>							For Date: <b>$templateData[\"PAYMENT_DATE\"]</b><br />            Total Number of Payments: <b>$templateData[\"TODAYS_TOTAL_PAYMENTS\"]</b><br />			Total Payment Amount: <b>$templateData[\"TODAYS_TOTAL_AMOUNT\"]</b><br/><br/>			Till Date: <b>$templateData[\"PAYMENT_DATE\"]</b><br />			Total Number of Payments: <b>$templateData[\"TILL_DATE_TOTAL_PAYEMNTS\"]</b><br />			Total Payment Amount: <b>$templateData[\"TILL_DATE_TOTAL_AMOUNT\"]</b><br/><br/> 			For more details please find attached copy.				</p>				</td></tr>				<tr><td  align=\"center\" style=\"background-color: #727272; margin:0px; padding:4px;\"><img src=\"http://www.serosoft.in/mailer/academia_email.png\" /></td></tr></table>' WHERE `id` = @msgtemplateId+1;

SET @msgtemplateconfigdocId=(SELECT MAX(id) FROM msg_template_config_doc);
INSERT INTO `msg_template_config_doc` (`id`, `msgTemplateconfigId`, `sysMsgEvtRcpntdocId`) VALUES (@msgtemplateconfigdocId+1, @msgtemplateconfigId+1, @sysmsgevtrcpntdocId+1); 
-- sample template config query END
-- ========================================================================================================================

-- Start : Added By Mohit for Additional Info
-- V201609141900
SET @dydtdataproviderId=(SELECT MAX(id) FROM dydt_data_provider);
INSERT INTO `dydt_data_provider` VALUES (@dydtdataproviderId+1,'Student Father Info',1),(@dydtdataproviderId+2,'Student Mother Info',1);

SET @dydtdatalineitemId=(SELECT MAX(id) FROM dydt_data_line_item);
INSERT INTO `dydt_data_line_item` VALUES (@dydtdatalineitemId+1,@dydtdataproviderId+1,'Student Fathers Info',1,NULL,1,1,'select per_father.firstName as father_first_name,per_father.lastName as father_last_name from students st\nINNER JOIN persons per ON st.personId=per.id \n   INNER JOIN person_relationships per_rel ON per.id=per_rel.personId and per_rel.relationship=\'FATHER\'\n   INNER JOIN persons per_father ON per_rel.relatedPersonId=per_father.id','PRM_STUDENT_ID','father_first_name,father_last_name',NULL,'where per_rel.whetherDeleted=0 and st.userId=PRM_STUDENT_ID',0),(@dydtdatalineitemId+2,@dydtdataproviderId+2,'Student Mothers Info',1,NULL,1,1,'select per_mother.firstName as mother_first_name,per_mother.lastName as mother_last_name from students st\nINNER JOIN persons per ON st.personId=per.id \n   INNER JOIN person_relationships per_rel ON per.id=per_rel.personId and per_rel.relationship=\'MOTHER\'\n   INNER JOIN persons per_mother ON per_rel.relatedPersonId=per_mother.id','PRM_STUDENT_ID','mother_first_name,mother_last_name',NULL,'where per_rel.whetherDeleted=0 and st.userId=PRM_STUDENT_ID',0);

update `dydt_data_line_item` set sqlSelectQueryDef='SELECT p.firstName AS student_firstname ,p.lastName AS student_lastname ,p.middleName AS student_middlename,p.gender AS student_gender,p.printName  AS student_printname,sln.salutationName AS applicant_salutation,p.birthDate AS birth_date,cc.itemCode as student_caste,r.itemCode as student_religion,cou.countryName as student_country FROM students s INNER JOIN  persons p ON s.personId = p.id INNER JOIN salutations sln ON p.salutationId = sln.id INNER JOIN caste_categories cc ON p.castCategoryId=cc.id INNER JOIN religions r ON p.religionId=r.id INNER JOIN country cou ON p.countryId=cou.id' where id=17 and dataProviderId=5 and dataSourceCode='ADMISSION_INFO';

update `dydt_data_line_item` set resultColumnsDef='student_firstname,student_lastname,student_middlename,student_gender,student_printname,applicant_salutation,birth_date,student_caste,student_religion,student_country' where id=17 and dataProviderId=5 and dataSourceCode='ADMISSION_INFO';

-- End : Added By Mohit for Additional Info


-- Start : Added By Mohit for Offer letter print issue
UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`='SELECT applicationId AS application_id ,programId AS program_id ,academyLocationId AS academy_location_id,a.applicantPersonId as applicant_person_id , progBatchSeatConfigId as program_batch_seat_configid FROM application_program ap left join application a on ap.applicationId = a.id' WHERE `dataSourceCode`='OFFER_LETTER_ADDITIONAL_PARAM';

UPDATE `dydt_data_line_item` 
SET 
    `sqlSelectQueryDef` = 'SELECT  p.programCode AS program_code,p.programName AS program_name,p.programNameToBePrint AS program_print_name,
     pd.shortCode AS primary_dept_code,pd.deptName AS primary_dept_name,
     psd.shortCode AS secondary_dept_code,psd.deptName AS secondary_dept_name,
     b.batchName AS batch_name ,b.startDate AS batch_start_date ,b.tillDate AS batch_tilldate
     FROM application_program aprgm
     LEFT JOIN programs p ON aprgm.programId = p.id
     LEFT JOIN prog_batch_seat_config pbsc ON aprgm.progBatchSeatConfigId = pbsc.id
     LEFT JOIN batches b   ON b.id = pbsc.programBatchId
     LEFT JOIN department pd ON pd.id = p.programDepartmentId
     LEFT JOIN department psd ON psd.id = p.subDepartmentId',
    resultColumnsDef = 'program_code,program_name,program_print_name,primary_dept_code,primary_dept_name,secondary_dept_code,secondary_dept_name, batch_name, batch_start_date,batch_end_date,batch_tilldate'
WHERE
    `dataSourceCode` = 'APPLICATION_INFO'
        AND `executionOrder` = 2;
        
UPDATE `dydt_data_line_item` 
SET 
    `sqlSelectQueryDef` = 'SELECT ap.firstName AS applicant_firstname ,ap.lastName AS applicant_lastname ,ap.middleName AS applicant_middlename, 
     ap.gender AS applicant_gender,ap.printName  AS applicant_printname,a.code as application_code,
     s.salutationName as applicant_salutation,ap.birthDate as birth_date,ap.photoUrl as app_photo_url
     FROM application a
     LEFT JOIN  applicant_person ap ON a.applicantPersonId = ap.id
     LEFT JOIN salutations s ON ap.salutationId = s.id',
    resultColumnsDef = 'applicant_firstname,applicant_lastname,applicant_middlename,applicant_gender,applicant_printname,application_code,applicant_salutation,birth_date,app_photo_url'
WHERE
    `dataSourceCode` = 'APPLICATION_INFO'
        AND executionOrder = '3';

UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`=' SELECT \n al.academyId AS academy_id , al.locationId AS location_id , al.academyName AS academy_name , al.locationName AS location_name,\n c.countryName AS country_name , cr.countryRegionName AS region_name ,\n pr.countryRegionName AS parent_region_name,ct.cityName AS city_name , addressText AS address_detail,\n ad.phoneCountryCode AS phone_country_code,ad.phoneAreaCode AS phone_area_code,\n ad.phoneNo AS phone_no ,ad.cellCountryCode AS cell_country_code,ad.cellNo AS cell_no,\n ad.primaryeEmailId as primary_email_id, al.path as img_academy_location\n FROM academy_location al\n LEFT JOIN location_addresses la ON al.locationId = la.locationId\n LEFT JOIN address ad ON la.addressId = ad.id AND ad.addressTypeId = 3\n LEFT JOIN city ct ON ct.id =ad.cityId\n LEFT JOIN country c ON ad.countryId = c.id\n LEFT JOIN country_region cr ON ad.countryRegionId = cr.id\n LEFT JOIN country_region pr ON ad.parentRegionId = pr.id' WHERE `dataSourceCode`='ACADEMYLOCATION_ADDRESS';

UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`='SELECT \n al.academyName as academy_name,al.locationName as location_name,\n p.programCode as program_code ,p.programName as program_name,p.programNameToBePrint as program_print_name ,\n b.batchName as batch_name,b.startDate as batch_start_date,b.tillDate as batch_till_date,\n st.seatCode as seat_code,st.seatName as seat_name \n from application_program ap\n LEFT JOIN academy_location al ON ap.academyLocationId = al.id\n LEFT JOIN programs p ON p.id = ap.programId\n LEFT JOIN prog_batch_seat_config pbsc ON pbsc.id  = ap.progBatchSeatConfigId \n LEFT JOIN batches b ON b.id = pbsc.programBatchId \n LEFT JOIN seat_types st ON pbsc.seatTypeId=st.id' WHERE `dataSourceCode`='APPLICATION_PROGRAM_INFO';

UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`='SELECT ap.firstName AS app_first_name,ap.middleName AS app_middle_name , ap.lastName AS app_last_name,\n        ap.mobileNumber AS app_mobile_number , ap.emailId AS app_email_id, ap.gender AS app_gender,\n        ap.birthDate AS app_birthdate, ap.bloodGroup AS app_bloodgroup, ap.photoURL AS img_app_photo_url,\n        ap.maritalStatus AS app_marital_status, ap.printName AS app_print_name,\n        ap.personalIncome AS app_personal_income, ap.occupation AS app_occupation,\n        ap.category AS app_category,a.code AS applctn_code,\n        cs.itemValue AS app_caste_category,rg.itemValue AS app_religion,nt.itemValue AS app_nationality,\n        cn.countryName AS app_country_name,sn.salutationName AS app_salutation\n FROM applicant_person ap \n LEFT JOIN application a ON a.applicantPersonId = ap.id\n LEFT JOIN caste_categories cs ON cs.id = ap.casteCategoryId\n LEFT JOIN religions rg ON rg.id = ap.religionId\n LEFT JOIN nationalities nt ON nt.id = ap.nationalityId\n LEFT JOIN country cn ON cn.id = ap.countryId        \n LEFT JOIN salutations sn ON sn.id = ap.salutationId' WHERE `dataSourceCode`='APPLICANT_INFO';

UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`=' SELECT o.orgName as organization_name,c.countryName AS country_name , cr.countryRegionName AS region_name ,\n pr.countryRegionName AS parent_region_name,ct.cityName AS city_name , addressText AS address_detail,\n ad.phoneCountryCode AS phone_country_code,ad.phoneAreaCode AS phone_area_code,\n ad.phoneNo AS phone_no ,ad.cellCountryCode AS cell_country_code,ad.cellNo AS cell_no,\n ad.primaryeEmailId AS primary_email_id\n FROM organizations o\n LEFT JOIN organization_addresses oa ON o.id = oa.organizationId\n LEFT JOIN address ad ON oa.addressId = ad.id AND ad.addressTypeId AND ad.addressTypeId=1\n LEFT JOIN city ct ON ct.id =ad.cityId\n LEFT JOIN country c ON ad.countryId = c.id\n LEFT JOIN country_region cr ON ad.countryRegionId = cr.id\n LEFT JOIN country_region pr ON ad.parentRegionId = pr.id' WHERE `dataSourceCode`='ORGANIZATION_ADDRESS';

UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`='\n SELECT    dt.itemCode AS document_code ,dt.itemValue AS document_name ,ard.status AS document_submission_status \n FROM application_program ap\n LEFT JOIN program_selection_process psp ON psp.programBatchSeatConfigId = ap.progBatchSeatConfigId\n LEFT JOIN application_required_documents ard ON psp.id = ard.programSelectionProcessId\n LEFT JOIN document_types dt ON ard.documentTypeId = dt.id' WHERE `dataSourceCode`='ADMISSION_PENDING_DOCUMENTS';

UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`=' SELECT p.printName AS sales_head_printname,p.mobileNumber as sales_head_mobile\n FROM academy_location_purpose alp\n LEFT JOIN staffs s ON s.userId = alp.ownerId\n LEFT JOIN persons p ON p.id = s.personId' WHERE `dataSourceCode`='ACAD_LCTN_SALES_OWNER';

UPDATE `dydt_data_line_item` 
SET 
    `sqlSelectQueryDef` = 'SELECT b.bankCode AS bank_code,b.ifscCode AS ifsc_code,b.accountNo AS bank_account_no, b.bankName AS bank_name,
    b.branchName AS branch_name,b.branchAddress AS bank_branch_address
    FROM bank b
    INNER JOIN academies a ON b.academyId = a.id
    INNER JOIN locations l ON b.locationId = l.id
    INNER JOIN academy_location al ON al.academyId = a.id AND al.locationId = l.id'
WHERE
    `dataSourceCode` = 'ACADEMY_LOCATION_BANKS';


UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`='select apf.printName as father_name from applicant_person_relationships as apr\n LEFT join applicant_person as ap on apr.applicantPersonId = ap.id\n LEFT join applicant_person as apf on apr.relatedApplicantPersonId = apf.id' WHERE `dataSourceCode`='APPLICANT_FATHER_NAME';


UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`='select round(datediff(b.tillDate,b.startDate) / 365) as batch_year, \n DATE_FORMAT(b.startDate ,\'%d-%m-%Y\') as batch_start_date,\n if(b.batchPartTime=1, \'Part Time\', \'Full Time\') as batch_study_mode \n from application_program as ap\n LEFT join prog_batch_seat_config as pbsc on ap.progBatchSeatConfigId = pbsc.id\n LEFT join batches as b on pbsc.programBatchId = b.id' WHERE `dataSourceCode`='BATCH_DETAILS';

UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`='SELECT  p.programCode AS program_code,p.programName AS program_name,p.programNameToBePrint AS program_print_name,\n pd.shortCode AS primary_dept_code,pd.deptName AS primary_dept_name,\n psd.shortCode AS secondary_dept_code,psd.deptName AS secondary_dept_name,\n b.batchName AS batch_name ,b.startDate AS batch_start_date ,b.tillDate AS batch_tilldate,\n ay.yearName AS academic_year ,a.code AS admission_code ,a.studentId as student_id\n FROM admission a\n LEFT JOIN programs p ON a.programId = p.id\n LEFT JOIN prog_batch_seat_config pbsc ON a.programBatchSeatConfigId = pbsc.id\n LEFT JOIN batches b   ON b.id = pbsc.programBatchId\n LEFT JOIN academy_year ay ON ay.id = b.academicYear\n LEFT JOIN department pd ON pd.id = p.programDepartmentId\n LEFT JOIN department psd ON psd.id = p.subDepartmentId' WHERE `dataSourceCode`='ADMISSION_INFO' and `publishAsParametersDef`='student_id=PRM_STUDENT_ID';
UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`='SELECT p.firstName AS student_firstname ,p.lastName AS student_lastname ,p.middleName AS student_middlename,p.gender AS student_gender,p.printName  AS student_printname,sln.salutationName AS applicant_salutation,p.birthDate AS birth_date,cc.itemCode as student_caste,r.itemCode as student_religion,cou.countryName as student_country FROM students s LEFT JOIN  persons p ON s.personId = p.id LEFT JOIN salutations sln ON p.salutationId = sln.id LEFT JOIN caste_categories cc ON p.castCategoryId=cc.id LEFT JOIN religions r ON p.religionId=r.id LEFT JOIN country cou ON p.countryId=cou.id' WHERE `dataSourceCode`='ADMISSION_INFO' and `publishAsParametersDef` is null;


UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`=' SELECT academy.academyName AS academy_name,academy.academicTypeCode AS academic_type_code,academy.shortCode AS academy_short_code,location.locationName AS location_name,location.shortCode AS location_short_code \n FROM academy_location al\n LEFT JOIN academies academy ON academy.id=al.academyId\n LEFT JOIN locations location ON location.id=al.locationId' WHERE `dataSourceCode`='ACADEMY_LOCATION_INFO';

UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`='SELECT T3.sponsorshipPercentage AS sponsorshipPercentage,T3.amountType AS amountType,T3.amount AS amount\n FROM sponsorship_awardees T1\n LEFT JOIN sponsorship_awarded_items T2 ON T2.sponsorshipAwardeeId=T1.id\n LEFT JOIN sponsorship_installments T3 ON T3.sponsorshipAwardedItemId=T2.id' WHERE `dataSourceCode`='SPONSORSHIP_INSTALLMENT_INFO';

UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`=' SELECT 	T2.itemCode AS documentCode,T2.itemValue AS documentName\n FROM `application_required_documents` T1\n LEFT JOIN document_types T2 ON T2.id = T1.documentTypeId' WHERE `dataSourceCode`='SELECTION_STAGE_PENDING_DOCUMENT_INFO';


UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`=' select per_father.firstName as father_first_name,per_father.lastName as father_last_name from students st\n LEFT JOIN persons per ON st.personId=per.id \n    LEFT JOIN person_relationships per_rel ON per.id=per_rel.personId and per_rel.relationship=\'FATHER\'\n    LEFT JOIN persons per_father ON per_rel.relatedPersonId=per_father.id' WHERE `dataSourceCode`='Student Fathers Info';

UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`='	select per_mother.firstName as mother_first_name,per_mother.lastName as mother_last_name from students st\n LEFT JOIN persons per ON st.personId=per.id \n    LEFT JOIN person_relationships per_rel ON per.id=per_rel.personId and per_rel.relationship=\'MOTHER\'\n    LEFT JOIN persons per_mother ON per_rel.relatedPersonId=per_mother.id\n ' WHERE `dataSourceCode`='Student Mothers Info';

INSERT INTO `dydt_data_provider` (`providerName`, `priority`) VALUES ('STUDENT_ADDRESS_INFO', '1');
SET @maxId1=(SELECT MAX(dataProviderId) FROM `dydt_data_line_item`);
INSERT INTO `dydt_data_line_item` (`dataProviderId`, `dataSourceCode`, `executionOrder`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`) 
VALUES (@maxId1+1, 'STUDENT_ADDRESS_INFO', '1', '1', '1', 'select\n        addr.addressText\n    from\n        students s \n    left outer join\n        persons p \n            on s.personId=p.id \n    left outer join\n        person_addresses pa \n           on p.id=pa.personId  and pa.whetherPrimary=true\n	 left outer join\n        address addr \n            on pa.addressId=addr.id', 'PRM_STUDENT_ID', 'addressText', 'where   s.userId =PRM_STUDENT_ID\r  group by s.userId', '0');

INSERT INTO `dydt_data_provider` (`providerName`, `priority`) VALUES ('STUDENT_ACADEMIC_TENUER_INFO', '1');
SET @maxId2=(SELECT MAX(dataProviderId) FROM `dydt_data_line_item`);
INSERT INTO `dydt_data_line_item` (`dataProviderId`, `dataSourceCode`, `executionOrder`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`) 
VALUES (@maxId2+1, 'STUDENT_ACADEMIC_TENUER_INFO', '1', '1', '1', 'select\n        period.programPeriodName,\n		ay.yearName,\n		ayt.tenureName\n    from\n        program_batch_students pbs \n    left outer join\n        admission adm \n            on pbs.admissionId=adm.id \n    left outer join\n        students std \n           on adm.studentId=std.userId\n	 left outer join\n        prog_batch_period_config period \n            on period.id=progBatchPeriodConfigId\n	left outer join\n        academy_year ay \n	on ay.id=period.academicYear\n	left outer join\n        academy_year_tenure ayt \n	on ayt.id=period.academicYearTenureId', 'PRM_STUDENT_ID', 'programPeriodName,\nyearName,\ntenureName', 'where   std.userId =PRM_STUDENT_ID and pbs.isCurrentPeriod=true and pbs.isCurrentSection=true and pbs.isPeriodCompleted = false and\r pbs.exitDate is null\r  group by std.userId', '0');

UPDATE `dydt_data_line_item` SET `sqlSelectQueryDef`='SELECT p.firstName AS student_firstname ,p.lastName AS student_lastname ,p.middleName \nAS student_middlename,p.gender AS student_gender,p.printName  AS student_printname,\nsln.salutationName AS applicant_salutation,p.birthDate AS birth_date,cc.itemCode as \nstudent_caste,r.itemCode as student_religion,cou.countryName as student_country  , user.code as student_code \nFROM students s LEFT JOIN  persons p ON s.personId = p.id LEFT JOIN salutations sln ON \np.salutationId = sln.id LEFT JOIN caste_categories cc ON p.castCategoryId=cc.id \nLEFT JOIN religions r ON p.religionId=r.id LEFT JOIN country cou ON p.countryId=cou.id\nLEFT JOIN users user ON s.userId=user.id', `resultColumnsDef`='student_firstname,student_lastname,student_middlename,student_gender,student_printname,applicant_salutation,birth_date,student_caste,student_religion,student_country, student_code' WHERE `id`='17' and`whetherPrimaryDataSource`='1';

SET SQL_SAFE_UPDATES = 1;
-- End : Added By Mohit for Offer letter print issue